/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.internet;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ThreadsDownloader {
    private final int totalThreadsCount;
    private int doneThreadsCount;
    private final int totalFilesCount;
    private int doneFilesCount;
    private final String preMessage;
    private boolean started;
    public final Map<Integer, List<Pair<String, File>>> maps;
    private final Void onDownloaded;
    private final boolean deleteTargetFileIfExist;

    public ThreadsDownloader(List<Pair<String, File>> files, boolean deleteTargetFileIfExist) {
        this(files, null, deleteTargetFileIfExist);
    }

    public ThreadsDownloader(List<Pair<String, File>> files, Void onDownloaded, boolean deleteTargetFileIfExist) {
        this(files, onDownloaded, 64, deleteTargetFileIfExist);
    }

    public ThreadsDownloader(List<Pair<String, File>> files, Void onDownloaded, int totalThreadsCount, boolean deleteTargetFileIfExist) {
        this.totalFilesCount = files.size();
        this.onDownloaded = onDownloaded;
        this.deleteTargetFileIfExist = deleteTargetFileIfExist;
        if (this.totalFilesCount > 0) {
            int i;
            this.totalThreadsCount = Math.min(this.totalFilesCount, totalThreadsCount);
            this.maps = new HashMap<Integer, List<Pair<String, File>>>(this.totalThreadsCount);
            for (i = 0; i < this.totalThreadsCount; ++i) {
                this.maps.put(i, new LinkedList());
            }
            this.preMessage = "[%d/" + this.totalFilesCount + "]";
            if (this.totalFilesCount <= totalThreadsCount) {
                i = 0;
                for (Pair<String, File> entry : files) {
                    this.getMap(i).add(entry);
                    ++i;
                }
            } else {
                Pair<String, File> one;
                int j;
                int quotient = this.totalFilesCount / this.totalThreadsCount;
                int remainder = this.totalFilesCount % this.totalThreadsCount;
                for (int i2 = 0; i2 < this.totalThreadsCount; ++i2) {
                    int start;
                    List<Pair<String, File>> map = this.getMap(i2);
                    for (j = start = quotient * i2; j < start + quotient; ++j) {
                        one = files.get(j);
                        map.add(one);
                    }
                }
                if (remainder > 0) {
                    int start = quotient * this.totalThreadsCount;
                    for (int i3 = 0; i3 < this.totalThreadsCount; ++i3) {
                        List<Pair<String, File>> map = this.getMap(i3);
                        j = start + i3;
                        if (j >= this.totalFilesCount) continue;
                        one = files.get(j);
                        map.add(one);
                    }
                }
            }
        } else {
            this.totalThreadsCount = 0;
            this.maps = Collections.emptyMap();
            this.preMessage = "[%d/0]";
        }
    }

    public void start() {
        block7: {
            if (this.totalFilesCount <= 0) {
                this.started = true;
                if (this.onDownloaded != null) {
                    this.onDownloaded.execute();
                }
            }
            if (this.started) {
                return;
            }
            int i = 0;
            while (i < this.totalThreadsCount) {
                int finalI = i++;
                new Thread(() -> {
                    List<Pair<String, File>> map = this.getMap(finalI);
                    for (Pair<String, File> pair : map) {
                        String url = pair.getKey();
                        File file = pair.getValue();
                        if (CMCL.isEmpty(url)) {
                            this.doneAddOneFile();
                            System.out.println(String.format(this.preMessage, this.doneFilesCount) + CMCL.getString("EXCEPTION_NOT_FOUND_DOWNLOAD_LINK_WITH_FILENAME", file.getName()));
                            continue;
                        }
                        try {
                            DownloadUtils.multipleAttemptsDownload(url, file, this.deleteTargetFileIfExist);
                            this.doneAddOneFile();
                            System.out.println(String.format(this.preMessage, this.doneFilesCount) + url.substring(url.lastIndexOf(47) + 1));
                        }
                        catch (IOException e) {
                            this.doneAddOneFile();
                            System.out.println(String.format(this.preMessage, this.doneFilesCount) + Utils.downloadFileFailedText(url, file, e));
                        }
                    }
                    this.doneAddOneThread();
                }).start();
            }
            this.started = true;
            do {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.doneThreadsCount < this.totalThreadsCount);
            if (this.onDownloaded == null) break block7;
            this.onDownloaded.execute();
        }
    }

    private List<Pair<String, File>> getMap(int index) {
        if (index >= this.totalThreadsCount) {
            throw new RuntimeException("unsupported number");
        }
        return this.maps.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneAddOneThread() {
        ThreadsDownloader threadsDownloader = this;
        synchronized (threadsDownloader) {
            ++this.doneThreadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneAddOneFile() {
        ThreadsDownloader threadsDownloader = this;
        synchronized (threadsDownloader) {
            ++this.doneFilesCount;
        }
    }
}

