/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.json;

import com.mrshiehx.cmcl.utils.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    public static JSONObject parseJSONObject(String jsonObjectString) {
        if (Utils.isEmpty(jsonObjectString)) {
            return null;
        }
        try {
            return new JSONObject(jsonObjectString);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static JSONArray parseJSONArray(String jsonArrayString) {
        if (Utils.isEmpty(jsonArrayString)) {
            return null;
        }
        try {
            return new JSONArray(jsonArrayString);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<JSONObject> jsonArrayToJSONObjectList(JSONArray jsonArray) {
        return JSONUtils.jsonArrayToJSONObjectList(jsonArray, null);
    }

    public static List<JSONObject> jsonArrayToJSONObjectList(JSONArray jsonArray, Predicate<JSONObject> filter) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return new LinkedList<JSONObject>();
        }
        Stream<JSONObject> stream = Utils.iteratorToStream(jsonArray.iterator()).filter(x -> x instanceof JSONObject).map(x -> (JSONObject)x);
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return stream.collect(Collectors.toList());
    }
}

