/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.json;

import com.mrshiehx.cmcl.utils.json.XJSONTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.JSONTokener;

public class XJSONObject
extends JSONObject {
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");

    public XJSONObject() {
        try {
            Field f = JSONObject.class.getDeclaredField("map");
            f.setAccessible(true);
            f.set(this, new LinkedHashMap());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public XJSONObject(String source) throws JSONException {
        this(new XJSONTokener(source));
    }

    public XJSONObject(Map<?, ?> m) {
        try {
            Field f = JSONObject.class.getDeclaredField("map");
            f.setAccessible(true);
            if (m == null) {
                f.set(this, new LinkedHashMap());
            } else {
                f.set(this, new LinkedHashMap(m.size()));
                for (Map.Entry<?, ?> entry : m.entrySet()) {
                    if (entry.getKey() == null) {
                        throw new NullPointerException("Null key.");
                    }
                    Object value = entry.getValue();
                    if (value == null) continue;
                    ((LinkedHashMap)f.get(this)).put(String.valueOf(entry.getKey()), XJSONObject.wrap(value));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XJSONObject(XJSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block11: while (true) {
            char prev;
            try {
                Method method = JSONTokener.class.getDeclaredMethod("getPrevious", new Class[0]);
                method.setAccessible(true);
                prev = ((Character)method.invoke((Object)x, new Object[0])).charValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '[': 
                case '{': {
                    if (prev == '{') {
                        throw x.syntaxError("A JSON Object can not directly nest another JSON Object or JSON Array.");
                    }
                }
                default: {
                    x.back();
                    String key = x.nextValue().toString();
                    c = x.nextClean();
                    if (c != ':') {
                        throw x.syntaxError("Expected a ':' after a key");
                    }
                    if (key != null) {
                        if (this.opt(key) != null) {
                            throw x.syntaxError("Duplicate key \"" + key + "\"");
                        }
                        Object value = x.nextValue();
                        if (value != null) {
                            this.put(key, value);
                        }
                    }
                    switch (x.nextClean()) {
                        case ',': 
                        case ';': {
                            if (x.nextClean() == '}') {
                                return;
                            }
                            x.back();
                            continue block11;
                        }
                        case '}': {
                            return;
                        }
                    }
                    throw x.syntaxError("Expected a ',' or '}'");
                }
                case '}': 
            }
            break;
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean needsComma = false;
            int length = this.length();
            writer.write(123);
            int newIndent = indent + indentFactor;
            if (length == 1) {
                Map.Entry<String, Object> entry = this.entrySet().iterator().next();
                if (indentFactor > 0) {
                    writer.write(10);
                }
                for (int i = 0; i < newIndent; ++i) {
                    writer.write(32);
                }
                String key = entry.getKey();
                writer.write(XJSONObject.quote(key));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                try {
                    XJSONObject.writeValue(writer, entry.getValue(), indentFactor, newIndent);
                }
                catch (Exception var12) {
                    throw new JSONException("Unable to write JSONObject value for key: " + key, var12);
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                for (int i = 0; i < indent; ++i) {
                    writer.write(32);
                }
            } else if (length != 0) {
                for (Map.Entry<String, Object> entry : this.entrySet()) {
                    if (needsComma) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    for (int i = 0; i < newIndent; ++i) {
                        writer.write(32);
                    }
                    String key = entry.getKey();
                    writer.write(XJSONObject.quote(key));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    try {
                        XJSONObject.writeValue(writer, entry.getValue(), indentFactor, newIndent);
                    }
                    catch (Exception var11) {
                        throw new JSONException("Unable to write JSONObject value for key: " + key, var11);
                    }
                    needsComma = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                for (int i = 0; i < indent; ++i) {
                    writer.write(32);
                }
            }
            writer.write(125);
            return writer;
        }
        catch (IOException var13) {
            throw new JSONException(var13);
        }
    }

    static Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value != null && !value.equals(null)) {
            if (value instanceof JSONString) {
                String numberAsString;
                try {
                    numberAsString = ((JSONString)value).toJSONString();
                }
                catch (Exception var6) {
                    throw new JSONException(var6);
                }
                writer.write(numberAsString != null ? numberAsString.toString() : XJSONObject.quote(value.toString()));
            } else if (value instanceof Number) {
                String numberAsString = XJSONObject.numberToString((Number)value);
                if (NUMBER_PATTERN.matcher(numberAsString).matches()) {
                    writer.write(numberAsString);
                } else {
                    XJSONObject.quote(numberAsString, writer);
                }
            } else if (value instanceof Boolean) {
                writer.write(value.toString());
            } else if (value instanceof Enum) {
                writer.write(XJSONObject.quote(((Enum)value).name()));
            } else if (value instanceof XJSONObject) {
                ((XJSONObject)value).write(writer, indentFactor, indent);
            } else if (value instanceof JSONObject) {
                new XJSONObject(((JSONObject)value).toMap()).write(writer, indentFactor, indent);
            } else if (value instanceof JSONArray) {
                JSONArray a = new JSONArray((JSONArray)value){

                    @Override
                    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
                        try {
                            ArrayList myArrayList;
                            boolean needsComma = false;
                            int length = this.length();
                            writer.write(91);
                            try {
                                Field f = JSONArray.class.getDeclaredField("myArrayList");
                                f.setAccessible(true);
                                myArrayList = (ArrayList)f.get(this);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return null;
                            }
                            if (length == 1) {
                                int ix;
                                int newIndent = indent + indentFactor;
                                if (indentFactor > 0) {
                                    writer.write(10);
                                }
                                for (ix = 0; ix < newIndent; ++ix) {
                                    writer.write(32);
                                }
                                try {
                                    XJSONObject.writeValue(writer, myArrayList.get(0), indentFactor, newIndent);
                                }
                                catch (Exception e) {
                                    throw new JSONException("Unable to write JSONArray value at index: 0", e);
                                }
                                if (indentFactor > 0) {
                                    writer.write(10);
                                }
                                for (ix = 0; ix < indent; ++ix) {
                                    writer.write(32);
                                }
                            } else if (length != 0) {
                                int newIndent = indent + indentFactor;
                                for (int i = 0; i < length; ++i) {
                                    if (needsComma) {
                                        writer.write(44);
                                    }
                                    if (indentFactor > 0) {
                                        writer.write(10);
                                    }
                                    for (int ix = 0; ix < newIndent; ++ix) {
                                        writer.write(32);
                                    }
                                    try {
                                        XJSONObject.writeValue(writer, myArrayList.get(i), indentFactor, newIndent);
                                    }
                                    catch (Exception e) {
                                        throw new JSONException("Unable to write JSONArray value at index: " + i, e);
                                    }
                                    needsComma = true;
                                }
                                if (indentFactor > 0) {
                                    writer.write(10);
                                }
                                for (int ix = 0; ix < indent; ++ix) {
                                    writer.write(32);
                                }
                            }
                            writer.write(93);
                            return writer;
                        }
                        catch (IOException e) {
                            throw new JSONException(e);
                        }
                    }
                };
                a.write(writer, indentFactor, indent);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                new XJSONObject(map).write(writer, indentFactor, indent);
            } else if (value instanceof Collection) {
                Collection coll = (Collection)value;
                new JSONArray(coll).write(writer, indentFactor, indent);
            } else if (value.getClass().isArray()) {
                new JSONArray(value).write(writer, indentFactor, indent);
            } else {
                XJSONObject.quote(value.toString(), writer);
            }
        } else {
            writer.write("null");
        }
        return writer;
    }
}

