/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.program;

import com.mrshiehx.cmcl.constants.languages.LanguageEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FindOutRedundantStrings {
    public static void main2(String[] args) throws IOException {
        System.out.println("en:");
        FindOutRedundantStrings.main(LanguageEnum.ENGLISH.getTextMap());
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("can:");
        FindOutRedundantStrings.main(LanguageEnum.CANTONESE.getTextMap());
    }

    public static void main(Map<String, String> map) throws IOException {
        File dir = new File("build/classes/java/main");
        LinkedList<File> files = new LinkedList<File>();
        FindOutRedundantStrings.traverseGetFiles(files, dir);
        LinkedList<String> contents = new LinkedList<String>();
        for (File file : files) {
            if (file.getName().equals("Cantonese.class") || file.getName().equals("SimplifiedChinese.class") || file.getName().equals("English.class") || file.getName().equals(FindOutRedundantStrings.class.getSimpleName() + ".class")) continue;
            contents.add(FindOutRedundantStrings.readFileContent(file, true));
        }
        HashSet<String> finall = new HashSet<String>();
        for (String name : map.keySet()) {
            boolean contains = false;
            for (String content : contents) {
                if (!content.contains(name)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            finall.add(name);
        }
        for (String s : finall) {
            System.out.println(s);
        }
    }

    public static String readFileContent(File file, boolean switchLine) throws IOException {
        String tempStr;
        StringBuilder sbf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((tempStr = reader.readLine()) != null) {
            sbf.append(tempStr);
            if (!switchLine) continue;
            sbf.append('\n');
        }
        reader.close();
        return sbf.toString();
    }

    static void traverseGetFiles(List<File> list, File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            list.add(file);
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File file1 : files) {
                if (file1.isFile()) {
                    if (file1.getName().equals("strings.xml") || file1.getName().endsWith(".png")) continue;
                    list.add(file1);
                    continue;
                }
                FindOutRedundantStrings.traverseGetFiles(list, file1);
            }
        }
    }
}

