/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.system;

import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.system.OperatingSystem;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUtils {
    public static String getDefaultJavaPath() {
        String s = System.getProperty("java.home");
        return Utils.isEmpty(s) ? "" : new File(s, SystemUtils.isWindows() ? "bin\\java.exe" : "bin/java").getAbsolutePath();
    }

    public static String getOriginalJavaVersion(String javaFile) {
        try {
            Matcher m;
            String version = null;
            Process process = new ProcessBuilder(javaFile, "-XshowSettings:properties", "-version").start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), OperatingSystem.NATIVE_CHARSET));){
                String line;
                while ((line = reader.readLine()) != null) {
                    m = Pattern.compile("java\\.version = (?<version>.*)").matcher(line);
                    if (!m.find()) continue;
                    version = m.group("version");
                    break;
                }
            }
            if (version == null) {
                process = new ProcessBuilder(javaFile, "-version").start();
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), OperatingSystem.NATIVE_CHARSET));
                var4_5 = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        m = Pattern.compile("version \"(?<version>(.*?))\"").matcher(line);
                        if (!m.find()) continue;
                        version = m.group("version");
                        break;
                    }
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (var4_5 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            return version;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getJavaVersion(String javaFile) {
        try {
            String version = JavaUtils.getOriginalJavaVersion(javaFile);
            if (version != null) {
                if (version.startsWith("1.")) {
                    version = version.substring(2, 3);
                } else {
                    int dot = version.indexOf(".");
                    if (dot != -1) {
                        version = version.substring(0, dot);
                    }
                }
                return Integer.parseInt(version);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

