/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.system;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;

public enum OperatingSystem {
    WINDOWS("windows"),
    LINUX("linux"),
    OSX("osx"),
    UNKNOWN("universal");

    private final String checkedName;
    public static final OperatingSystem CURRENT_OS;
    public static final Charset NATIVE_CHARSET;

    private OperatingSystem(String checkedName) {
        this.checkedName = checkedName;
    }

    public String getCheckedName() {
        return this.checkedName;
    }

    static {
        String name = System.getProperty("os.name").toLowerCase(Locale.US);
        CURRENT_OS = name.contains("win") ? WINDOWS : (name.contains("mac") ? OSX : (name.contains("solaris") || name.contains("linux") || name.contains("unix") || name.contains("sunos") ? LINUX : UNKNOWN));
        Charset nativeCharset = Charset.defaultCharset();
        String nativeEncoding = System.getProperty("native.encoding");
        try {
            if (nativeEncoding != null && !nativeEncoding.equalsIgnoreCase(nativeCharset.name())) {
                nativeCharset = Charset.forName(nativeEncoding);
            }
            if (nativeCharset == StandardCharsets.UTF_8 || nativeCharset == StandardCharsets.US_ASCII) {
                nativeCharset = StandardCharsets.UTF_8;
            } else if ("GBK".equalsIgnoreCase(nativeCharset.name()) || "GB2312".equalsIgnoreCase(nativeCharset.name())) {
                nativeCharset = Charset.forName("GB18030");
            }
        }
        catch (UnsupportedCharsetException e) {
            e.printStackTrace();
        }
        NATIVE_CHARSET = nativeCharset;
    }
}

