/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ToggleButtonSkin;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleNode;
import com.jfoenix.transitions.JFXFillTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXToggleNodeSkin
extends ToggleButtonSkin {
    private final StackPane main = new StackPane();
    private JFXRippler rippler;
    private boolean invalid = true;
    private JFXFillTransition ft;
    private Runnable releaseManualRippler = null;

    public JFXToggleNodeSkin(JFXToggleNode toggleNode) {
        super(toggleNode);
        CornerRadii defaultRadii = new CornerRadii(3.0);
        toggleNode.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, defaultRadii, null)}));
        toggleNode.setText(null);
        this.main.setPickOnBounds(false);
        ((ToggleButton)this.getSkinnable()).setPickOnBounds(false);
        StackPane toggleNodeContainer = new StackPane();
        toggleNodeContainer.getChildren().add((Object)((ToggleButton)this.getSkinnable()).getGraphic());
        toggleNodeContainer.prefWidthProperty().bind((ObservableValue)((ToggleButton)this.getSkinnable()).widthProperty());
        toggleNodeContainer.prefHeightProperty().bind((ObservableValue)((ToggleButton)this.getSkinnable()).heightProperty());
        this.rippler = new JFXRippler((Node)toggleNodeContainer, JFXRippler.RipplerPos.FRONT){

            @Override
            protected Node getMask() {
                StackPane mask = new StackPane();
                mask.shapeProperty().bind((ObservableValue)JFXToggleNodeSkin.this.main.shapeProperty());
                mask.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, JFXToggleNodeSkin.this.main.backgroundProperty().get() != null ? ((BackgroundFill)JFXToggleNodeSkin.this.main.getBackground().getFills().get(0)).getRadii() : CornerRadii.EMPTY, JFXToggleNodeSkin.this.main.backgroundProperty().get() != null ? ((BackgroundFill)JFXToggleNodeSkin.this.main.getBackground().getFills().get(0)).getInsets() : Insets.EMPTY)}), (Observable[])new Observable[]{JFXToggleNodeSkin.this.main.backgroundProperty()}));
                mask.resize(JFXToggleNodeSkin.this.main.getWidth(), JFXToggleNodeSkin.this.main.getHeight());
                return mask;
            }

            @Override
            protected void initListeners() {
                this.ripplerPane.setOnMousePressed(event -> {
                    if (JFXToggleNodeSkin.this.releaseManualRippler != null) {
                        JFXToggleNodeSkin.this.releaseManualRippler.run();
                    }
                    JFXToggleNodeSkin.this.releaseManualRippler = null;
                    this.createRipple(event.getX(), event.getY());
                });
            }
        };
        this.main.getChildren().add((Object)this.rippler);
        this.main.borderProperty().bind((ObservableValue)((ToggleButton)this.getSkinnable()).borderProperty());
        ObjectBinding backgroundBinding = Bindings.createObjectBinding(() -> {
            CornerRadii radii = toggleNode.getBackground() == null ? null : ((BackgroundFill)toggleNode.getBackground().getFills().get(0)).getRadii();
            Insets insets = toggleNode.getBackground() == null ? null : Insets.EMPTY;
            return new Background(new BackgroundFill[]{new BackgroundFill((Paint)(toggleNode.isSelected() ? toggleNode.getSelectedColor() : toggleNode.getUnSelectedColor()), radii, insets)});
        }, (Observable[])new Observable[]{toggleNode.unSelectedColorProperty(), toggleNode.backgroundProperty()});
        this.main.backgroundProperty().bind((ObservableValue)backgroundBinding);
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener((o, oldVal, newVal) -> {
            this.main.backgroundProperty().unbind();
            if (!toggleNode.isDisableAnimation().booleanValue()) {
                if (this.ft == null) {
                    this.ft = new JFXFillTransition(Duration.millis((double)120.0), (Region)this.main);
                    this.ft.toValueProperty().bind(toggleNode.selectedColorProperty());
                    this.ft.fromValueProperty().bind(toggleNode.unSelectedColorProperty());
                }
                this.ft.stop();
                this.ft.setRate(newVal != false ? 1.0 : -1.0);
                this.ft.play();
            } else {
                CornerRadii radii = ((ToggleButton)this.getSkinnable()).getBackground() == null ? CornerRadii.EMPTY : ((BackgroundFill)((ToggleButton)this.getSkinnable()).getBackground().getFills().get(0)).getRadii();
                Insets insets = ((ToggleButton)this.getSkinnable()).getBackground() == null ? Insets.EMPTY : ((BackgroundFill)((ToggleButton)this.getSkinnable()).getBackground().getFills().get(0)).getInsets();
                this.main.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleNode)this.getSkinnable()).getSelectedColor() : ((JFXToggleNode)this.getSkinnable()).getUnSelectedColor()), radii, insets)}));
            }
        });
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.releaseManualRippler = this.rippler.createManualRipple();
            } else if (this.releaseManualRippler != null) {
                this.releaseManualRippler.run();
            }
        });
        toggleNode.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!((ToggleButton)this.getSkinnable()).isPressed()) {
                    this.rippler.showOverlay();
                }
            } else {
                this.rippler.hideOverlay();
            }
        });
        toggleNode.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.hideOverlay());
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.main != null) {
            this.getChildren().add(0, (Object)this.main);
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Node)this.getChildren().get(i)).setMouseTransparent(true);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.invalid) {
            this.invalid = false;
        }
        double shift = 1.0;
        this.main.resizeRelocate(((ToggleButton)this.getSkinnable()).getLayoutBounds().getMinX() - shift, ((ToggleButton)this.getSkinnable()).getLayoutBounds().getMinY() - shift, ((ToggleButton)this.getSkinnable()).getWidth() + 2.0 * shift, ((ToggleButton)this.getSkinnable()).getHeight() + 2.0 * shift);
    }
}

