/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import org.jackhuang.hmcl.BootProperties;
import org.jackhuang.hmcl.EntryPoint;
import org.jackhuang.hmcl.util.SwingUtils;

public final class Main {
    private static final int MINIMUM_JAVA_VERSION = 17;

    private Main() {
    }

    static int findFirstNotNumber(String str, int start) {
        if (start >= str.length()) {
            return -1;
        }
        char ch = str.charAt(start);
        if (ch < '0' || ch > '9') {
            return -1;
        }
        for (int i = start + 1; i < str.length(); ++i) {
            ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return i;
        }
        return str.length();
    }

    static int getJavaFeatureVersion(String javaVersion) {
        if (javaVersion == null) {
            return -1;
        }
        try {
            int end = Main.findFirstNotNumber(javaVersion, 0);
            if (end < 0) {
                return -1;
            }
            int major = Integer.parseInt(javaVersion.substring(0, end));
            if (major > 1) {
                return major;
            }
            if (major < 1) {
                return -1;
            }
            int start = end + 1;
            if ((end = Main.findFirstNotNumber(javaVersion, start)) < 0) {
                return -1;
            }
            return Integer.parseInt(javaVersion.substring(start, end));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static void main(String[] args) throws Throwable {
        if (Main.getJavaFeatureVersion(System.getProperty("java.version")) >= 17) {
            EntryPoint.main(args);
        } else {
            String errorMessage = BootProperties.getResourceBundle().getString("boot.unsupported_java_version");
            System.err.println(errorMessage);
            SwingUtils.showErrorDialog(errorMessage);
            System.exit(1);
        }
    }
}

