/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.cleanroom;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.UnsupportedInstallationException;
import org.jackhuang.hmcl.download.VersionMismatchException;
import org.jackhuang.hmcl.download.cleanroom.CleanroomRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallTask;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;

public final class CleanroomInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private Path installer;
    private final CleanroomRemoteVersion remote;
    private FileDownloadTask dependent;
    private Task<Version> task;

    public CleanroomInstallTask(DefaultDependencyManager dependencyManager, Version version, CleanroomRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.remote = remoteVersion;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        this.installer = Files.createTempFile("cleanroom-installer", ".jar", new FileAttribute[0]);
        this.dependent = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLsWithCandidates(this.remote.getUrls()), this.installer, null);
        this.dependent.setCacheRepository(this.dependencyManager.getCacheRepository());
        this.dependent.setCaching(true);
        this.dependent.addIntegrityCheckHandler(FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER);
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        Files.deleteIfExists(this.installer);
        this.setResult(this.task.getResult());
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.dependent);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return Collections.singleton(this.task);
    }

    @Override
    public void execute() throws IOException, VersionMismatchException, UnsupportedInstallationException {
        this.task = new ForgeNewInstallTask(this.dependencyManager, this.version, this.remote.getSelfVersion(), this.installer).thenApplyAsync(version -> version.setId(LibraryAnalyzer.LibraryType.CLEANROOM.getPatchId()));
    }
}

