/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.cleanroom;

import java.time.Instant;
import java.util.Collections;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.cleanroom.CleanroomRemoteVersion;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;

public final class CleanroomVersionList
extends VersionList<CleanroomRemoteVersion> {
    private final DownloadProvider downloadProvider;
    private static final String LOADER_LIST_URL = "https://hmcl-dev.github.io/metadata/cleanroom/index.json";
    private static final String INSTALLER_URL = "https://hmcl-dev.github.io/metadata/cleanroom/files/cleanroom-%s-installer.jar";

    public CleanroomVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> refreshAsync() {
        return Task.allOf(new GetTask(this.downloadProvider.injectURLWithCandidates(LOADER_LIST_URL)).thenGetJsonAsync(ReleaseResult[].class)).thenAcceptAsync(results -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                for (ReleaseResult version : (ReleaseResult[])results.get(0)) {
                    this.versions.put("1.12.2", new CleanroomRemoteVersion("1.12.2", version.name, Instant.parse(version.created_at), Collections.singletonList(String.format(INSTALLER_URL, version.name))));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static final class ReleaseResult {
        String name;
        String created_at;

        private ReleaseResult() {
        }
    }
}

