/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.terracotta.TerracottaNative;
import org.jackhuang.hmcl.terracotta.provider.GeneralProvider;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.terracotta.provider.MacOSProvider;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.LocalizedText;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public final class TerracottaMetadata {
    public static final ITerracottaProvider PROVIDER;
    public static final String PACKAGE_NAME;
    private static final List<Link> PACKAGE_LINKS;
    private static final Pattern LEGACY;
    private static final List<String> RECENT;
    private static final String LATEST;

    private TerracottaMetadata() {
    }

    public static List<Link> getPackageLinks() {
        return PACKAGE_LINKS;
    }

    @Nullable
    private static ProviderContext locateProvider(Config config) {
        String architecture;
        switch (Architecture.SYSTEM_ARCH) {
            case X86_64: {
                String string = "x86_64";
                break;
            }
            case ARM64: {
                String string = "arm64";
                break;
            }
            default: {
                String string = architecture = null;
            }
        }
        if (architecture == null) {
            return null;
        }
        return switch (OperatingSystem.CURRENT_OS) {
            case OperatingSystem.WINDOWS -> {
                if (OperatingSystem.SYSTEM_VERSION.isAtLeast(OSVersion.WINDOWS_8_1)) {
                    yield new ProviderContext(new GeneralProvider(config.of(String.format("windows-%s.exe", architecture))), "windows", architecture);
                }
                yield null;
            }
            case OperatingSystem.LINUX -> new ProviderContext(new GeneralProvider(config.of(String.format("linux-%s", architecture))), "linux", architecture);
            case OperatingSystem.MACOS -> new ProviderContext(new MacOSProvider(config.of(String.format("macos-%s.pkg", architecture)), config.of(String.format("macos-%s", architecture))), "macos", architecture);
            default -> null;
        };
    }

    public static void removeLegacyVersionFiles() throws IOException {
        try (DirectoryStream<Path> terracotta = Files.newDirectoryStream(Metadata.DEPENDENCIES_DIRECTORY.resolve("terracotta").toAbsolutePath());){
            for (Path path : terracotta) {
                String name = FileUtils.getName(path);
                if (LATEST.equals(name) || RECENT.contains(name) || !LEGACY.matcher(name).matches()) continue;
                try {
                    FileUtils.deleteDirectory(path);
                }
                catch (IOException e) {
                    Logger.LOG.warning(String.format("Unable to remove legacy terracotta files: %s", path), e);
                }
            }
        }
    }

    public static boolean hasLegacyVersionFiles() throws IOException {
        try (DirectoryStream<Path> terracotta = Files.newDirectoryStream(Metadata.DEPENDENCIES_DIRECTORY.resolve("terracotta").toAbsolutePath());){
            for (Path path : terracotta) {
                String name = FileUtils.getName(path);
                if (LATEST.equals(name) || !RECENT.contains(name) && !LEGACY.matcher(name).matches()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    static {
        Config config;
        try (InputStream is = TerracottaMetadata.class.getResourceAsStream("/assets/terracotta.json");){
            config = JsonUtils.fromNonNullJsonFully(is, Config.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LEGACY = Pattern.compile(config.legacy);
        RECENT = config.recent;
        LATEST = config.latest;
        ProviderContext context = TerracottaMetadata.locateProvider(config);
        PROVIDER = context != null ? context.provider() : null;
        String string = PACKAGE_NAME = context != null ? String.format("terracotta-%s-%s-pkg.tar.gz", config.latest, context.branch) : null;
        if (context != null) {
            ArrayList<Link> packageLinks = new ArrayList<Link>(config.links.size());
            for (Link link : config.links) {
                packageLinks.add(new Link(link.description, link.link.replace("${version}", LATEST).replace("${classifier}", context.branch)));
            }
            Collections.shuffle(packageLinks);
            PACKAGE_LINKS = Collections.unmodifiableList(packageLinks);
        } else {
            PACKAGE_LINKS = null;
        }
    }

    private record ProviderContext(ITerracottaProvider provider, String branch) {
        ProviderContext(ITerracottaProvider provider, String system, String arch) {
            this(provider, system + "-" + arch);
        }
    }

    private record Config(@SerializedName(value="version_legacy") String legacy, @SerializedName(value="version_recent") List<String> recent, @SerializedName(value="version_latest") String latest, @SerializedName(value="classifiers") Map<String, String> classifiers, @SerializedName(value="downloads") List<String> downloads, @SerializedName(value="links") List<Link> links) {
        private TerracottaNative of(String classifier) {
            ArrayList<URI> links = new ArrayList<URI>(this.downloads.size());
            for (String download : this.downloads) {
                links.add(URI.create(download.replace("${version}", this.latest).replace("${classifier}", classifier)));
            }
            String hash = Objects.requireNonNull(this.classifiers.get(classifier), String.format("Classifier %s doesn't exist.", classifier));
            if (!hash.startsWith("sha256:")) {
                throw new IllegalArgumentException(String.format("Invalid hash value %s for classifier %s.", hash, classifier));
            }
            hash = hash.substring("sha256:".length());
            return new TerracottaNative(Collections.unmodifiableList(links), Metadata.DEPENDENCIES_DIRECTORY.resolve(String.format("terracotta/%s/terracotta-%s-%s", this.latest, this.latest, classifier)).toAbsolutePath(), new FileDownloadTask.IntegrityCheck("SHA-256", hash));
        }
    }

    public record Link(@SerializedName(value="desc") LocalizedText description, String link) {
    }
}

