/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.Optional;
import java.util.Stack;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.util.logging.Logger;

public class Navigator
extends TransitionPane {
    private static final String PROPERTY_DIALOG_CLOSE_HANDLER = Navigator.class.getName() + ".closeListener";
    private final BooleanProperty backable = new SimpleBooleanProperty((Object)this, "backable");
    private final Stack<Node> stack = new Stack();
    private boolean initialized = false;
    private ObjectProperty<EventHandler<NavigationEvent>> onNavigated = new SimpleObjectProperty<EventHandler<NavigationEvent>>((Object)this, "onNavigated"){

        protected void invalidated() {
            Navigator.this.setEventHandler(NavigationEvent.NAVIGATED, (EventHandler)this.get());
        }
    };
    private ObjectProperty<EventHandler<NavigationEvent>> onNavigating = new SimpleObjectProperty<EventHandler<NavigationEvent>>((Object)this, "onNavigating"){

        protected void invalidated() {
            Navigator.this.setEventHandler(NavigationEvent.NAVIGATING, (EventHandler)this.get());
        }
    };

    public void init(Node init) {
        this.stack.push(init);
        this.backable.set(this.canGoBack());
        this.getChildren().setAll((Object[])new Node[]{init});
        this.fireEvent(new NavigationEvent(this, init, Navigation.NavigationDirection.START, NavigationEvent.NAVIGATED));
        if (init instanceof PageAware) {
            ((PageAware)init).onPageShown();
        }
        this.initialized = true;
    }

    public void navigate(Node node, AnimationProducer animationProducer) {
        FXUtils.checkFxUserThread();
        if (!this.initialized) {
            throw new IllegalStateException("Navigator must have a root page");
        }
        Node from = this.stack.peek();
        if (from == node) {
            return;
        }
        Logger.LOG.info("Navigate to " + String.valueOf(node));
        this.stack.push(node);
        this.backable.set(this.canGoBack());
        NavigationEvent navigating = new NavigationEvent(this, from, Navigation.NavigationDirection.NEXT, NavigationEvent.NAVIGATING);
        this.fireEvent(navigating);
        node.fireEvent((Event)navigating);
        node.getProperties().put((Object)"hmcl.navigator.animation", (Object)animationProducer);
        this.setContent(node, animationProducer);
        NavigationEvent navigated = new NavigationEvent(this, node, Navigation.NavigationDirection.NEXT, NavigationEvent.NAVIGATED);
        node.fireEvent((Event)navigated);
        if (node instanceof PageAware) {
            ((PageAware)node).onPageShown();
        }
        EventHandler handler = event -> this.close(node);
        node.getProperties().put((Object)PROPERTY_DIALOG_CLOSE_HANDLER, (Object)handler);
        node.addEventHandler(PageCloseEvent.CLOSE, handler);
    }

    public void close() {
        this.close(this.stack.peek());
    }

    public void clear() {
        while (this.stack.size() > 1) {
            this.close(this.stack.peek());
        }
    }

    public void close(Node from) {
        FXUtils.checkFxUserThread();
        if (!this.initialized) {
            throw new IllegalStateException("Navigator must have a root page");
        }
        if (this.stack.peek() != from) {
            Logger.LOG.info("Closing already closed page: " + String.valueOf(from), new Throwable());
            return;
        }
        Logger.LOG.info("Closed page " + String.valueOf(from));
        Node poppedNode = this.stack.pop();
        NavigationEvent exited = new NavigationEvent(this, poppedNode, Navigation.NavigationDirection.PREVIOUS, NavigationEvent.EXITED);
        poppedNode.fireEvent((Event)exited);
        if (poppedNode instanceof PageAware) {
            ((PageAware)poppedNode).onPageHidden();
        }
        this.backable.set(this.canGoBack());
        Node node = this.stack.peek();
        NavigationEvent navigating = new NavigationEvent(this, from, Navigation.NavigationDirection.PREVIOUS, NavigationEvent.NAVIGATING);
        this.fireEvent(navigating);
        node.fireEvent((Event)navigating);
        Object obj = from.getProperties().get((Object)"hmcl.navigator.animation");
        if (obj instanceof AnimationProducer) {
            this.setContent(node, (AnimationProducer)obj);
        } else {
            this.setContent(node, ContainerAnimations.NONE);
        }
        NavigationEvent navigated = new NavigationEvent(this, node, Navigation.NavigationDirection.PREVIOUS, NavigationEvent.NAVIGATED);
        node.fireEvent((Event)navigated);
        Optional.ofNullable(from.getProperties().get((Object)PROPERTY_DIALOG_CLOSE_HANDLER)).ifPresent(handler -> from.removeEventHandler(PageCloseEvent.CLOSE, (EventHandler)handler));
    }

    public Node getCurrentPage() {
        return this.stack.peek();
    }

    public boolean canGoBack() {
        return this.stack.size() > 1;
    }

    public boolean isBackable() {
        return this.backable.get();
    }

    public BooleanProperty backableProperty() {
        return this.backable;
    }

    public void setBackable(boolean backable) {
        this.backable.set(backable);
    }

    public int size() {
        return this.stack.size();
    }

    @Override
    public void setContent(Node content, AnimationProducer animationProducer) {
        super.setContent(content, animationProducer);
        if (content instanceof Region) {
            ((Region)content).setMinSize(0.0, 0.0);
            FXUtils.setOverflowHidden((Region)content);
        }
    }

    public EventHandler<NavigationEvent> getOnNavigated() {
        return (EventHandler)this.onNavigated.get();
    }

    public ObjectProperty<EventHandler<NavigationEvent>> onNavigatedProperty() {
        return this.onNavigated;
    }

    public void setOnNavigated(EventHandler<NavigationEvent> onNavigated) {
        this.onNavigated.set(onNavigated);
    }

    public EventHandler<NavigationEvent> getOnNavigating() {
        return (EventHandler)this.onNavigating.get();
    }

    public ObjectProperty<EventHandler<NavigationEvent>> onNavigatingProperty() {
        return this.onNavigating;
    }

    public void setOnNavigating(EventHandler<NavigationEvent> onNavigating) {
        this.onNavigating.set(onNavigating);
    }

    public static class NavigationEvent
    extends Event {
        public static final EventType<NavigationEvent> EXITED = new EventType("EXITED");
        public static final EventType<NavigationEvent> NAVIGATED = new EventType("NAVIGATED");
        public static final EventType<NavigationEvent> NAVIGATING = new EventType("NAVIGATING");
        private final Navigator source;
        private final Node node;
        private final Navigation.NavigationDirection direction;

        public NavigationEvent(Navigator source, Node target, Navigation.NavigationDirection direction, EventType<? extends Event> eventType) {
            super((Object)source, (EventTarget)target, eventType);
            this.source = source;
            this.node = target;
            this.direction = direction;
        }

        public Navigator getSource() {
            return this.source;
        }

        public Node getNode() {
            return this.node;
        }

        public Navigation.NavigationDirection getDirection() {
            return this.direction;
        }
    }
}

