/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.terracotta;

import com.jfoenix.controls.JFXProgressBar;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaManager;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.TerracottaState;
import org.jackhuang.hmcl.terracotta.profile.TerracottaProfile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class TerracottaControllerPage
extends StackPane {
    private static final ObjectProperty<TerracottaState> UI_STATE = new SimpleObjectProperty();
    private final WeakListenerHolder holder = new WeakListenerHolder();

    public TerracottaControllerPage() {
        TransitionPane transition = new TransitionPane();
        SimpleObjectProperty statusProperty = new SimpleObjectProperty();
        SimpleDoubleProperty progressProperty = new SimpleDoubleProperty();
        ObservableList nodesProperty = FXCollections.observableList(new ArrayList());
        FXUtils.applyDragListener((Node)this, path -> {
            TerracottaState.Fatal fatal;
            TerracottaState.Preparing preparing;
            TerracottaState state = (TerracottaState)UI_STATE.get();
            if (state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Preparing && (preparing = (TerracottaState.Preparing)state).hasInstallFence() || state instanceof TerracottaState.Fatal && (fatal = (TerracottaState.Fatal)state).getType() == TerracottaState.Fatal.Type.NETWORK) {
                return Files.isReadable(path) && FileUtils.getName(path).toLowerCase(Locale.ROOT).endsWith(".tar.gz");
            }
            return false;
        }, files -> {
            TerracottaState.Fatal fatal;
            TerracottaState next;
            TerracottaState.Preparing preparing;
            Path path = (Path)files.get(0);
            if (!TerracottaManager.validate(path)) {
                Controllers.dialog(I18n.i18n("terracotta.from_local.file_name_mismatch", TerracottaMetadata.PACKAGE_NAME, FileUtils.getName(path)), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                return;
            }
            TerracottaState state = (TerracottaState)UI_STATE.get();
            if (state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Preparing && (preparing = (TerracottaState.Preparing)state).hasInstallFence()) {
                TerracottaState.Uninitialized uninitialized;
                if (state instanceof TerracottaState.Uninitialized && !(uninitialized = (TerracottaState.Uninitialized)state).hasLegacy()) {
                    Controllers.confirmActionDanger(I18n.i18n("terracotta.confirm.desc"), I18n.i18n("terracotta.confirm.title"), () -> {
                        TerracottaState.Preparing s = TerracottaManager.install(path);
                        if (s != null) {
                            UI_STATE.set((Object)s);
                        }
                    }, () -> {});
                    return;
                }
                next = TerracottaManager.install(path);
            } else if (state instanceof TerracottaState.Fatal && (fatal = (TerracottaState.Fatal)state).getType() == TerracottaState.Fatal.Type.NETWORK) {
                next = TerracottaManager.recover(path);
            } else {
                return;
            }
            if (next != null) {
                UI_STATE.set((Object)next);
            }
        });
        ChangeListener listener = (arg_0, arg_1, arg_2) -> this.lambda$new$29((DoubleProperty)progressProperty, (ObjectProperty)statusProperty, nodesProperty, transition, arg_0, arg_1, arg_2);
        listener.changed(UI_STATE, null, (Object)((TerracottaState)UI_STATE.get()));
        this.holder.add(listener);
        UI_STATE.addListener((ChangeListener)new WeakChangeListener(listener));
        VBox content = new VBox(10.0);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("terracotta.status")), transition});
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        scrollPane.setFitToWidth(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
    }

    private ComponentList getThirdPartyDownloadNodes() {
        ComponentSublist locals = new ComponentSublist();
        locals.setComponentPadding(false);
        LineButton header = LineButton.of(false);
        header.setLeftImage(FXUtils.newBuiltinImage("/assets/img/terracotta.png"));
        header.setTitle(I18n.i18n("terracotta.from_local.title"));
        header.setSubtitle(I18n.i18n("terracotta.from_local.desc"));
        locals.setHeaderLeft((Node)header);
        for (TerracottaMetadata.Link link : TerracottaMetadata.getPackageLinks()) {
            HBox node = new HBox();
            node.setAlignment(Pos.CENTER_LEFT);
            node.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
            Label description = new Label(link.description().getText(I18n.getLocale().getCandidateLocales()));
            HBox placeholder = new HBox();
            HBox.setHgrow((Node)placeholder, (Priority)Priority.ALWAYS);
            Node icon = SVG.OPEN_IN_NEW.createIcon((Paint)Theme.blackFill(), 16.0);
            node.getChildren().setAll((Object[])new Node[]{description, placeholder, icon});
            String url = link.link();
            RipplerContainer container = new RipplerContainer((Node)node);
            container.setOnMouseClicked(ev -> Controllers.dialog(I18n.i18n("terracotta.from_local.guide", TerracottaMetadata.PACKAGE_NAME), I18n.i18n("message.info"), MessageDialogPane.MessageType.INFO, () -> FXUtils.openLink(url)));
            container.getProperties().put((Object)"ComponentList.noPadding", (Object)true);
            locals.getContent().add((Object)container);
        }
        return locals;
    }

    private /* synthetic */ void lambda$new$29(DoubleProperty progressProperty, ObjectProperty statusProperty, ObservableList nodesProperty, TransitionPane transition, ObservableValue _uiState, TerracottaState legacyState, TerracottaState state) {
        if (legacyState != null && legacyState.isUIFakeState() && !state.isUIFakeState() && legacyState.getClass() == state.getClass()) {
            return;
        }
        progressProperty.unbind();
        if (state instanceof TerracottaState.Bootstrap) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.bootstrap"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Uninitialized) {
            TerracottaState.Uninitialized uninitialized = (TerracottaState.Uninitialized)state;
            String fork = uninitialized.hasLegacy() ? "update" : "not_exist";
            statusProperty.set((Object)I18n.i18n("terracotta.status.uninitialized." + fork));
            progressProperty.set(0.0);
            TextFlow body = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.confirm.desc"), Controllers::onHyperlinkAction);
            body.setLineSpacing(4.0);
            LineButton download = LineButton.of();
            download.setLeftImage(FXUtils.newBuiltinImage("/assets/img/terracotta.png"));
            download.setTitle(I18n.i18n(String.format("terracotta.status.uninitialized.%s.title", fork)));
            download.setSubtitle(I18n.i18n("terracotta.status.uninitialized.desc"));
            download.setRightIcon(SVG.ARROW_FORWARD);
            FXUtils.onClicked((Node)download, () -> {
                if (uninitialized.hasLegacy()) {
                    TerracottaState.Preparing s = TerracottaManager.install(null);
                    if (s != null) {
                        UI_STATE.set((Object)s);
                    }
                } else {
                    Controllers.confirmActionDanger(I18n.i18n("terracotta.confirm.desc"), I18n.i18n("terracotta.confirm.title"), () -> {
                        TerracottaState.Preparing s = TerracottaManager.install(null);
                        if (s != null) {
                            UI_STATE.set((Object)s);
                        }
                    }, () -> {});
                }
            });
            nodesProperty.setAll((Object[])new Node[]{body, download, this.getThirdPartyDownloadNodes()});
        } else if (state instanceof TerracottaState.Preparing) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.preparing"));
            progressProperty.bind((ObservableValue)((TerracottaState.Preparing)state).progressProperty());
            nodesProperty.setAll((Object[])new Node[]{this.getThirdPartyDownloadNodes()});
        } else if (state instanceof TerracottaState.Launching) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.launching"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Unknown) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.unknown"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Waiting) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.waiting"));
            progressProperty.set(1.0);
            TextFlow flow = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.confirm.desc"), Controllers::onHyperlinkAction);
            flow.setLineSpacing(4.0);
            LineButton host = LineButton.of();
            host.setLeftIcon(SVG.HOST);
            host.setTitle(I18n.i18n("terracotta.status.waiting.host.title"));
            host.setSubtitle(I18n.i18n("terracotta.status.waiting.host.desc"));
            host.setRightIcon(SVG.ARROW_FORWARD);
            FXUtils.onClicked((Node)host, () -> {
                if (LauncherHelper.countMangedProcesses() >= 1) {
                    TerracottaState.HostScanning s1 = TerracottaManager.setScanning();
                    if (s1 != null) {
                        UI_STATE.set((Object)s1);
                    }
                } else {
                    Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("terracotta.status.waiting.host.launch.desc"), I18n.i18n("terracotta.status.waiting.host.launch.title"), MessageDialogPane.MessageType.QUESTION).addAction(I18n.i18n("version.launch"), () -> {
                        Profile profile = Profiles.getSelectedProfile();
                        Versions.launch(profile, profile.getSelectedVersion(), LauncherHelper::setKeep);
                    }).addCancel(I18n.i18n("terracotta.status.waiting.host.launch.skip"), () -> {
                        TerracottaState.HostScanning s1 = TerracottaManager.setScanning();
                        if (s1 != null) {
                            UI_STATE.set((Object)s1);
                        }
                    }).addCancel(() -> {}).build());
                }
            });
            LineButton guest = LineButton.of();
            guest.setLeftIcon(SVG.ADD_CIRCLE);
            guest.setTitle(I18n.i18n("terracotta.status.waiting.guest.title"));
            guest.setSubtitle(I18n.i18n("terracotta.status.waiting.guest.desc"));
            guest.setRightIcon(SVG.ARROW_FORWARD);
            FXUtils.onClicked((Node)guest, () -> Controllers.prompt(I18n.i18n("terracotta.status.waiting.guest.prompt.title"), (code, resolve, reject) -> {
                Task<TerracottaState.GuestStarting> task = TerracottaManager.setGuesting(code);
                if (task != null) {
                    task.whenComplete(Schedulers.javafx(), (s, e) -> {
                        if (e != null) {
                            reject.accept(I18n.i18n("terracotta.status.waiting.guest.prompt.invalid"));
                        } else {
                            resolve.run();
                            UI_STATE.set(s);
                        }
                    }).setSignificance(Task.TaskSignificance.MINOR).start();
                } else {
                    resolve.run();
                }
            }));
            nodesProperty.setAll((Object[])new Node[]{flow, host, guest});
        } else if (state instanceof TerracottaState.HostScanning) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.scanning"));
            progressProperty.set(-1.0);
            TextFlow body = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.status.scanning.desc"), Controllers::onHyperlinkAction);
            body.setLineSpacing(4.0);
            LineButton room = LineButton.of();
            room.setLeftIcon(SVG.ARROW_BACK);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.scanning.back"));
            FXUtils.onClicked((Node)room, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            nodesProperty.setAll((Object[])new Node[]{body, room});
        } else if (state instanceof TerracottaState.HostStarting) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.host_starting"));
            progressProperty.set(-1.0);
            LineButton room = LineButton.of();
            room.setLeftIcon(SVG.ARROW_BACK);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.host_starting.back"));
            FXUtils.onClicked((Node)room, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            nodesProperty.setAll((Object[])new Node[]{room});
        } else if (state instanceof TerracottaState.HostOK) {
            TerracottaState.HostOK hostOK = (TerracottaState.HostOK)state;
            if (hostOK.isForkOf(legacyState)) {
                ((PlayerProfileUI)((Object)nodesProperty.get(nodesProperty.size() - 1))).updateProfiles(hostOK.getProfiles());
                return;
            }
            String cs = hostOK.getCode();
            statusProperty.set((Object)I18n.i18n("terracotta.status.host_ok"));
            progressProperty.set(1.0);
            VBox code = new VBox(4.0);
            code.setAlignment(Pos.CENTER);
            Label desc = new Label(I18n.i18n("terracotta.status.host_ok.code"));
            ClipboardContent cp = new ClipboardContent();
            cp.putString(cs);
            Clipboard.getSystemClipboard().setContent((Map)cp);
            TextField label = new TextField(cs);
            label.setEditable(false);
            label.setFocusTraversable(false);
            label.setAlignment(Pos.CENTER);
            label.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
            VBox.setMargin((Node)label, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
            label.setScaleX(1.8);
            label.setScaleY(1.8);
            this.holder.add(FXUtils.onWeakChange(label.selectedTextProperty(), string -> {
                if (string != null && !string.isEmpty() && !cs.equals(string)) {
                    label.selectAll();
                }
            }));
            code.getChildren().setAll((Object[])new Node[]{desc, label});
            FXUtils.onClicked((Node)code, () -> FXUtils.copyText(cs));
            LineButton copy = LineButton.of();
            copy.setLeftIcon(SVG.CONTENT_COPY);
            copy.setTitle(I18n.i18n("terracotta.status.host_ok.code.copy"));
            copy.setSubtitle(I18n.i18n("terracotta.status.host_ok.code.desc"));
            FXUtils.onClicked((Node)copy, () -> FXUtils.copyText(cs));
            LineButton back = LineButton.of();
            back.setLeftIcon(SVG.ARROW_BACK);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.host_ok.back"));
            FXUtils.onClicked((Node)back, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            nodesProperty.setAll((Object[])new Node[]{code, copy, back, new PlayerProfileUI(hostOK.getProfiles())});
        } else if (state instanceof TerracottaState.GuestStarting) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.guest_starting"));
            progressProperty.set(-1.0);
            LineButton room = LineButton.of();
            room.setLeftIcon(SVG.ARROW_BACK);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.guest_starting.back"));
            FXUtils.onClicked((Node)room, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            nodesProperty.setAll((Object[])new Node[]{room});
        } else if (state instanceof TerracottaState.GuestOK) {
            TerracottaState.GuestOK guestOK = (TerracottaState.GuestOK)state;
            if (guestOK.isForkOf(legacyState)) {
                ((PlayerProfileUI)((Object)nodesProperty.get(nodesProperty.size() - 1))).updateProfiles(guestOK.getProfiles());
                return;
            }
            statusProperty.set((Object)I18n.i18n("terracotta.status.guest_ok"));
            progressProperty.set(1.0);
            LineButton tutorial = LineButton.of();
            tutorial.setTitle(I18n.i18n("terracotta.status.guest_ok.title"));
            tutorial.setSubtitle(I18n.i18n("terracotta.status.guest_ok.desc", guestOK.getUrl()));
            LineButton back = LineButton.of();
            back.setLeftIcon(SVG.ARROW_BACK);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.guest_ok.back"));
            FXUtils.onClicked((Node)back, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            nodesProperty.setAll((Object[])new Node[]{tutorial, back, new PlayerProfileUI(guestOK.getProfiles())});
        } else if (state instanceof TerracottaState.Exception) {
            TerracottaState.Exception exception = (TerracottaState.Exception)state;
            statusProperty.set((Object)I18n.i18n("terracotta.status.exception.desc." + exception.getType().name().toLowerCase(Locale.ROOT)));
            progressProperty.set(1.0);
            nodesProperty.setAll((Object[])new Node[0]);
            LineButton back = LineButton.of();
            back.setLeftIcon(SVG.ARROW_BACK);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.exception.back"));
            FXUtils.onClicked((Node)back, () -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            });
            SpinnerPane exportLog = new SpinnerPane();
            LineButton exportLogInner = LineButton.of();
            exportLogInner.setLeftIcon(SVG.OUTPUT);
            exportLogInner.setTitle(I18n.i18n("terracotta.export_log"));
            exportLogInner.setSubtitle(I18n.i18n("terracotta.export_log.desc"));
            exportLog.setContent((Node)exportLogInner);
            exportLog.getProperties().put((Object)"ComponentList.noPadding", (Object)true);
            exportLog.minHeightProperty().bind((ObservableValue)back.heightProperty());
            FXUtils.onClicked((Node)exportLogInner, () -> {
                exportLog.setLoading(true);
                TerracottaManager.exportLogs().thenAcceptAsync(Schedulers.io(), data -> {
                    if (data == null || data.isEmpty()) {
                        return;
                    }
                    Path path = Path.of("terracotta-log-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".zip", new String[0]).toAbsolutePath();
                    try (Zipper zipper = new Zipper(path);){
                        zipper.putTextFile((String)data, StandardCharsets.UTF_8, "terracotta.log");
                        try (OutputStream os = zipper.putStream("hmcl-latest.log");){
                            Logger.LOG.exportLogs(os);
                        }
                    }
                    FXUtils.showFileInExplorer(path);
                }).thenRunAsync(() -> Thread.sleep(3000L)).whenComplete(Schedulers.javafx(), e -> exportLog.setLoading(false)).start();
            });
            nodesProperty.setAll((Object[])new Node[]{back, exportLog});
        } else if (state instanceof TerracottaState.Fatal) {
            TerracottaState.Fatal fatal = (TerracottaState.Fatal)state;
            String message = I18n.i18n("terracotta.status.fatal." + fatal.getType().name().toLowerCase(Locale.ROOT));
            statusProperty.set((Object)message);
            progressProperty.set(1.0);
            if (fatal.isRecoverable()) {
                LineButton retry = LineButton.of();
                retry.setLeftIcon(SVG.RESTORE);
                retry.setTitle(I18n.i18n("terracotta.status.fatal.retry"));
                retry.setSubtitle(message);
                FXUtils.onClicked((Node)retry, () -> {
                    TerracottaState s = TerracottaManager.recover(null);
                    if (s != null) {
                        UI_STATE.set((Object)s);
                    }
                });
                if (fatal.getType() == TerracottaState.Fatal.Type.NETWORK) {
                    nodesProperty.setAll((Object[])new Node[]{retry, this.getThirdPartyDownloadNodes()});
                } else {
                    nodesProperty.setAll((Object[])new Node[]{retry});
                }
            } else {
                nodesProperty.setAll((Object[])new Node[0]);
            }
        } else {
            throw new AssertionError((Object)state.getClass().getName());
        }
        ComponentList components = new ComponentList();
        VBox statusPane = new VBox(8.0);
        VBox.setMargin((Node)statusPane, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
        Label status = new Label();
        status.textProperty().bind((ObservableValue)statusProperty);
        JFXProgressBar progress = new JFXProgressBar();
        progress.progressProperty().bind((ObservableValue)progressProperty);
        progress.setMaxWidth(Double.MAX_VALUE);
        statusPane.getChildren().setAll((Object[])new Node[]{status, progress});
        ObservableList<Node> children = components.getContent();
        children.add((Object)statusPane);
        children.addAll((Collection)nodesProperty);
        transition.setContent((Node)components, ContainerAnimations.SWIPE_LEFT_FADE_SHORT);
    }

    static {
        FXUtils.onChangeAndOperate(TerracottaManager.stateProperty(), state -> {
            if (state != null) {
                UI_STATE.set(state);
            }
        });
    }

    private static final class LineButton
    extends RipplerContainer {
        private final WeakListenerHolder holder = new WeakListenerHolder();
        private final TwoLineListItem middle = new TwoLineListItem();
        private final ObjectProperty<Node> left = new SimpleObjectProperty();
        private final ObjectProperty<Node> right = new SimpleObjectProperty();

        public static LineButton of() {
            return LineButton.of(true);
        }

        public static LineButton of(boolean padding) {
            HBox container = new HBox();
            if (padding) {
                container.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
            }
            container.setAlignment(Pos.CENTER_LEFT);
            container.setCursor(Cursor.HAND);
            container.setSpacing(16.0);
            LineButton button = new LineButton((Node)container);
            VBox spacing = new VBox();
            HBox.setHgrow((Node)spacing, (Priority)Priority.ALWAYS);
            button.holder.add(FXUtils.observeWeak(() -> {
                ArrayList<Object> nodes = new ArrayList<Object>(4);
                Node left = (Node)button.left.get();
                if (left != null) {
                    nodes.add(left);
                }
                nodes.add((Object)button.middle);
                nodes.add(spacing);
                Node right = (Node)button.right.get();
                if (right != null) {
                    nodes.add(right);
                }
                container.getChildren().setAll(nodes);
            }, new Observable[]{button.middle.titleProperty(), button.middle.subtitleProperty(), button.left, button.right}));
            button.getProperties().put((Object)"ComponentList.noPadding", (Object)true);
            return button;
        }

        private LineButton(Node container) {
            super(container);
        }

        public void setTitle(String title) {
            this.middle.setTitle(title);
        }

        public void setSubtitle(String subtitle) {
            this.middle.setSubtitle(subtitle);
        }

        public void setLeftImage(Image left) {
            this.left.set((Object)new ImageView(left));
        }

        public void setLeftIcon(SVG left) {
            this.left.set((Object)left.createIcon((Paint)Theme.blackFill(), 28.0));
        }

        public void setRightIcon(SVG right) {
            this.right.set((Object)right.createIcon((Paint)Theme.blackFill(), 28.0));
        }
    }

    private static final class PlayerProfileUI
    extends VBox {
        private final TransitionPane transition;

        public PlayerProfileUI(List<TerracottaProfile> profiles) {
            super(8.0);
            VBox.setMargin((Node)this, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
            Label status = new Label();
            status.setText(I18n.i18n("terracotta.player_list"));
            this.transition = new TransitionPane();
            this.getChildren().setAll((Object[])new Node[]{status, this.transition});
            this.updateProfiles(profiles);
        }

        private void updateProfiles(List<TerracottaProfile> profiles) {
            VBox pane = new VBox(8.0);
            for (TerracottaProfile profile : profiles) {
                TwoLineListItem item = new TwoLineListItem();
                item.setTitle(profile.getName());
                item.setSubtitle(profile.getVendor());
                item.getTags().setAll((Object[])new Label[]{TwoLineListItem.createTagLabel(I18n.i18n("terracotta.player_kind." + profile.getType().name().toLowerCase(Locale.ROOT)))});
                pane.getChildren().add((Object)item);
            }
            this.transition.setContent((Node)pane, ContainerAnimations.SWIPE_LEFT_FADE_SHORT);
        }
    }
}

