/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.terracotta;

import java.util.Locale;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.terracotta.TerracottaControllerPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class TerracottaPage
extends DecoratorAnimatedPage
implements DecoratorPage,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("terracotta.terracotta")));
    private final TabHeader tab;
    private final TabControl.Tab<TerracottaControllerPage> statusPage = new TabControl.Tab("statusPage");
    private final TransitionPane transitionPane = new TransitionPane();

    public TerracottaPage() {
        this.statusPage.setNodeSupplier(TerracottaControllerPage::new);
        this.tab = new TabHeader(this.statusPage);
        this.tab.select(this.statusPage);
        this.transitionPane.setContent((Node)this.statusPage.getNode(), ContainerAnimations.NONE);
        FXUtils.onChange(this.tab.getSelectionModel().selectedItemProperty(), newValue -> this.transitionPane.setContent((Node)newValue.getNode(), ContainerAnimations.FADE));
        AdvancedListItem chatItem = new AdvancedListItem();
        chatItem.setLeftGraphic(VersionPage.wrap(SVG.CHAT));
        chatItem.setActionButtonVisible(false);
        chatItem.setTitle(I18n.i18n("chat"));
        chatItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> FXUtils.openLink("https://www.bilibili.com/opus/905435541874409529")));
        AdvancedListItem easytierItem = new AdvancedListItem();
        easytierItem.setLeftGraphic(VersionPage.wrap(SVG.HOST));
        easytierItem.setActionButtonVisible(false);
        easytierItem.setTitle(I18n.i18n("terracotta.easytier"));
        easytierItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> FXUtils.openLink("https://easytier.cn/")));
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(this.tab, this.statusPage, I18n.i18n("terracotta.status"), SVG.TUNE).startCategory(I18n.i18n("help").toUpperCase(Locale.ROOT)).add((Node)chatItem).add((Node)easytierItem);
        FXUtils.setLimitWidth((Region)sideBar, 200.0);
        this.setLeft(new Node[]{sideBar});
        this.setCenter(new Node[]{this.transitionPane});
    }

    @Override
    public void onPageShown() {
        this.tab.onPageShown();
    }

    @Override
    public void onPageHidden() {
        this.tab.onPageHidden();
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }
}

