/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CSVTable;

public class ModUpdatesPage
extends BorderPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("mods.check_updates")));
    private final ModManager modManager;
    private final ObservableList<ModUpdateObject> objects;

    public ModUpdatesPage(ModManager modManager, List<LocalModFile.ModUpdate> updates) {
        this.modManager = modManager;
        this.getStyleClass().add((Object)"gray-background");
        TableColumn enabledColumn = new TableColumn();
        CheckBox allEnabledBox = new CheckBox();
        enabledColumn.setGraphic((Node)allEnabledBox);
        enabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)enabledColumn));
        this.setupCellValueFactory(enabledColumn, ModUpdateObject::enabledProperty);
        enabledColumn.setEditable(true);
        enabledColumn.setMaxWidth(40.0);
        enabledColumn.setMinWidth(40.0);
        TableColumn fileNameColumn = new TableColumn(I18n.i18n("mods.check_updates.file"));
        fileNameColumn.setPrefWidth(200.0);
        this.setupCellValueFactory(fileNameColumn, ModUpdateObject::fileNameProperty);
        TableColumn currentVersionColumn = new TableColumn(I18n.i18n("mods.check_updates.current_version"));
        currentVersionColumn.setPrefWidth(200.0);
        this.setupCellValueFactory(currentVersionColumn, ModUpdateObject::currentVersionProperty);
        TableColumn targetVersionColumn = new TableColumn(I18n.i18n("mods.check_updates.target_version"));
        targetVersionColumn.setPrefWidth(200.0);
        this.setupCellValueFactory(targetVersionColumn, ModUpdateObject::targetVersionProperty);
        TableColumn sourceColumn = new TableColumn(I18n.i18n("mods.check_updates.source"));
        this.setupCellValueFactory(sourceColumn, ModUpdateObject::sourceProperty);
        this.objects = FXCollections.observableList(updates.stream().map(ModUpdateObject::new).collect(Collectors.toList()));
        FXUtils.bindAllEnabled(allEnabledBox.selectedProperty(), (BooleanProperty[])this.objects.stream().map(o -> o.enabled).toArray(BooleanProperty[]::new));
        TableView table = new TableView(this.objects);
        table.setEditable(true);
        table.getColumns().setAll((Object[])new TableColumn[]{enabledColumn, fileNameColumn, currentVersionColumn, targetVersionColumn, sourceColumn});
        this.setCenter((Node)table);
        HBox actions = new HBox(8.0);
        actions.setPadding(new Insets(8.0));
        actions.setAlignment(Pos.CENTER_RIGHT);
        JFXButton exportListButton = FXUtils.newRaisedButton(I18n.i18n("button.export"));
        exportListButton.setOnAction(e -> this.exportList());
        JFXButton nextButton = FXUtils.newRaisedButton(I18n.i18n("mods.check_updates.update"));
        nextButton.setOnAction(e -> this.updateMods());
        JFXButton cancelButton = FXUtils.newRaisedButton(I18n.i18n("button.cancel"));
        cancelButton.setOnAction(e -> this.fireEvent(new PageCloseEvent()));
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        actions.getChildren().setAll((Object[])new Node[]{exportListButton, nextButton, cancelButton});
        this.setBottom((Node)actions);
    }

    private <T> void setupCellValueFactory(TableColumn<ModUpdateObject, T> column, Function<ModUpdateObject, ObservableValue<T>> mapper) {
        column.setCellValueFactory(param -> (ObservableValue)mapper.apply((ModUpdateObject)param.getValue()));
    }

    private void updateMods() {
        ModUpdateTask task = new ModUpdateTask(this.modManager, this.objects.stream().filter(o -> o.enabled.get()).map(object -> Pair.pair(object.data.getLocalMod(), object.data.getCandidates().get(0))).collect(Collectors.toList()));
        Controllers.taskDialog(task.whenComplete(Schedulers.javafx(), exception -> {
            this.fireEvent(new PageCloseEvent());
            if (!task.getFailedMods().isEmpty()) {
                Controllers.dialog(I18n.i18n("mods.check_updates.failed_download") + "\n" + task.getFailedMods().stream().map(LocalModFile::getFileName).collect(Collectors.joining("\n")), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR);
            }
            if (exception == null) {
                Controllers.dialog(I18n.i18n("install.success"));
            }
        }), I18n.i18n("mods.check_updates.update"), TaskCancellationAction.NORMAL);
    }

    private void exportList() {
        Path path = Paths.get("hmcl-mod-update-list-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".csv", new String[0]).toAbsolutePath();
        Controllers.taskDialog(Task.runAsync(() -> {
            CSVTable csvTable = new CSVTable();
            csvTable.set(0, 0, "Source File Name");
            csvTable.set(1, 0, "Current Version");
            csvTable.set(2, 0, "Target Version");
            csvTable.set(3, 0, "Update Source");
            for (int i = 0; i < this.objects.size(); ++i) {
                csvTable.set(0, i + 1, (String)((ModUpdateObject)this.objects.get((int)i)).fileName.get());
                csvTable.set(1, i + 1, (String)((ModUpdateObject)this.objects.get((int)i)).currentVersion.get());
                csvTable.set(2, i + 1, (String)((ModUpdateObject)this.objects.get((int)i)).targetVersion.get());
                csvTable.set(3, i + 1, (String)((ModUpdateObject)this.objects.get((int)i)).source.get());
            }
            csvTable.write(path);
            FXUtils.showFileInExplorer(path);
        }).whenComplete(Schedulers.javafx(), exception -> {
            if (exception == null) {
                Controllers.dialog(path.toString(), I18n.i18n("message.success"));
            } else {
                Controllers.dialog("", I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            }
        }), I18n.i18n("button.export"), TaskCancellationAction.NORMAL);
    }

    public ReadOnlyObjectWrapper<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public static class ModUpdateTask
    extends Task<Void> {
        private final Collection<Task<?>> dependents;
        private final List<LocalModFile> failedMods = new ArrayList<LocalModFile>();

        ModUpdateTask(ModManager modManager, List<Pair<LocalModFile, RemoteMod.Version>> mods) {
            this.setStage("mods.check_updates.update");
            this.getProperties().put("total", mods.size());
            this.dependents = new ArrayList();
            for (Pair<LocalModFile, RemoteMod.Version> mod : mods) {
                LocalModFile local = mod.getKey();
                RemoteMod.Version remote = mod.getValue();
                boolean isDisabled = local.getModManager().isDisabled(local.getFile());
                this.dependents.add(Task.runAsync(Schedulers.javafx(), () -> local.setOld(true)).thenComposeAsync(() -> {
                    Object fileName = remote.getFile().getFilename();
                    if (isDisabled) {
                        fileName = (String)fileName + ".disabled";
                    }
                    FileDownloadTask task = new FileDownloadTask(remote.getFile().getUrl(), modManager.getModsDirectory().resolve((String)fileName));
                    task.setName(remote.getName());
                    return task;
                }).whenComplete(Schedulers.javafx(), (Exception exception) -> {
                    if (exception != null) {
                        local.setOld(false);
                        if (isDisabled) {
                            local.disable();
                        }
                        this.failedMods.add(local);
                    }
                }).withCounter("mods.check_updates.update"));
            }
        }

        public List<LocalModFile> getFailedMods() {
            return this.failedMods;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return this.dependents;
        }

        @Override
        public boolean doPreExecute() {
            return true;
        }

        @Override
        public void preExecute() {
            this.notifyPropertiesChanged();
        }

        @Override
        public boolean isRelyingOnDependents() {
            return false;
        }

        @Override
        public void execute() throws Exception {
            if (!this.isDependentsSucceeded()) {
                throw this.getException();
            }
        }
    }

    private static final class ModUpdateObject {
        final LocalModFile.ModUpdate data;
        final BooleanProperty enabled = new SimpleBooleanProperty();
        final StringProperty fileName = new SimpleStringProperty();
        final StringProperty currentVersion = new SimpleStringProperty();
        final StringProperty targetVersion = new SimpleStringProperty();
        final StringProperty source = new SimpleStringProperty();

        public ModUpdateObject(LocalModFile.ModUpdate data) {
            this.data = data;
            this.enabled.set(!data.getLocalMod().getModManager().isDisabled(data.getLocalMod().getFile()));
            this.fileName.set((Object)data.getLocalMod().getFileName());
            this.currentVersion.set((Object)data.getCurrentVersion().getVersion());
            this.targetVersion.set((Object)data.getCandidates().get(0).getVersion());
            switch (data.getCurrentVersion().getSelf().getType()) {
                case CURSEFORGE: {
                    this.source.set((Object)I18n.i18n("mods.curseforge"));
                    break;
                }
                case MODRINTH: {
                    this.source.set((Object)I18n.i18n("mods.modrinth"));
                }
            }
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }

        public BooleanProperty enabledProperty() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled.set(enabled);
        }

        public String getFileName() {
            return (String)this.fileName.get();
        }

        public StringProperty fileNameProperty() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName.set((Object)fileName);
        }

        public String getCurrentVersion() {
            return (String)this.currentVersion.get();
        }

        public StringProperty currentVersionProperty() {
            return this.currentVersion;
        }

        public void setCurrentVersion(String currentVersion) {
            this.currentVersion.set((Object)currentVersion);
        }

        public String getTargetVersion() {
            return (String)this.targetVersion.get();
        }

        public StringProperty targetVersionProperty() {
            return this.targetVersion;
        }

        public void setTargetVersion(String targetVersion) {
            this.targetVersion.set((Object)targetVersion);
        }

        public String getSource() {
            return (String)this.source.get();
        }

        public StringProperty sourceProperty() {
            return this.source;
        }

        public void setSource(String source) {
            this.source.set((Object)source);
        }
    }
}

