/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jackhuang.hmcl.util.logging.Logger;

public final class UpsideDownUtils {
    private static final Map<Integer, Integer> MAPPER = UpsideDownUtils.loadMap();
    private static final DateTimeFormatter BASE_FORMATTER = DateTimeFormatter.ofPattern("MMM d, yyyy, h:mm:ss a").withZone(ZoneId.systemDefault());

    private static Map<Integer, Integer> loadMap() {
        LinkedHashMap map = new LinkedHashMap();
        InputStream inputStream = UpsideDownUtils.class.getResourceAsStream("/assets/lang/upside_down.txt");
        if (inputStream != null) {
            try (InputStream inputStream2 = inputStream;){
                new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).lines().forEach(line -> {
                    if (line.isBlank() || line.startsWith("#")) {
                        return;
                    }
                    if (line.length() != 2) {
                        Logger.LOG.warning("Invalid line: " + line);
                        return;
                    }
                    map.put(Integer.valueOf(line.charAt(0)), Integer.valueOf(line.charAt(1)));
                });
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to load upside_down.txt", e);
            }
        } else {
            Logger.LOG.warning("upside_down.txt not found");
        }
        return Collections.unmodifiableMap(map);
    }

    public static String translate(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        str.codePoints().forEach(ch -> builder.appendCodePoint(MAPPER.getOrDefault(ch, ch)));
        return builder.reverse().toString();
    }

    public static String formatDateTime(TemporalAccessor time) {
        return UpsideDownUtils.translate(BASE_FORMATTER.format(time));
    }

    private UpsideDownUtils() {
    }
}

