/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class WenyanUtils {
    private static final String DOT = "\u9ede";
    private static final String[] NUMBERS = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u5eff", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u5345", "\u5345\u4e00", "\u5345\u4e8c", "\u5345\u4e09", "\u5345\u56db", "\u5345\u4e94", "\u5345\u516d", "\u5345\u4e03", "\u5345\u516b", "\u5345\u4e5d", "\u534c", "\u534c\u4e00", "\u534c\u4e8c", "\u534c\u4e09", "\u534c\u56db", "\u534c\u4e94", "\u534c\u516d", "\u534c\u4e03", "\u534c\u516b", "\u534c\u4e5d", "\u4e94\u5341", "\u4e94\u5341\u4e00", "\u4e94\u5341\u4e8c", "\u4e94\u5341\u4e09", "\u4e94\u5341\u56db", "\u4e94\u5341\u4e94", "\u4e94\u5341\u516d", "\u4e94\u5341\u4e03", "\u4e94\u5341\u516b", "\u4e94\u5341\u4e5d", "\u516d\u5341", "\u516d\u5341\u4e00", "\u516d\u5341\u4e8c", "\u516d\u5341\u4e09", "\u516d\u5341\u56db", "\u516d\u5341\u4e94", "\u516d\u5341\u516d", "\u516d\u5341\u4e03", "\u516d\u5341\u516b", "\u516d\u5341\u4e5d"};
    private static final char[] TIAN_GAN = new char[]{'\u7532', '\u4e59', '\u4e19', '\u4e01', '\u620a', '\u5df1', '\u5e9a', '\u8f9b', '\u58ec', '\u7678'};
    private static final char[] DI_ZHI = new char[]{'\u5b50', '\u4e11', '\u5bc5', '\u536f', '\u8fb0', '\u5df3', '\u5348', '\u672a', '\u7533', '\u9149', '\u620c', '\u4ea5'};
    private static final Pattern GENERIC_VERSION_PATTERN = Pattern.compile("^[0-9]+(\\.[0-9]+)*");

    private static String digitToString(char digit) {
        return digit >= '0' && digit <= '9' ? NUMBERS[digit - 48] : String.valueOf(digit);
    }

    private static String numberToString(int number) {
        return number >= 0 && number < NUMBERS.length ? NUMBERS[number] : String.valueOf(number);
    }

    private static void appendDigitByDigit(StringBuilder builder, String number) {
        for (int i = 0; i < number.length(); ++i) {
            builder.append(WenyanUtils.digitToString(number.charAt(i)));
        }
    }

    private static int mod(int a, int b) {
        int r = a % b;
        return r >= 0 ? r : r + b;
    }

    static void appendYear(StringBuilder builder, int year) {
        int yearOffset = year - 1984;
        builder.append(TIAN_GAN[WenyanUtils.mod(yearOffset, TIAN_GAN.length)]);
        builder.append(DI_ZHI[WenyanUtils.mod(yearOffset, DI_ZHI.length)]);
    }

    static void appendHour(StringBuilder builder, int hour) {
        builder.append(DI_ZHI[(hour + 1) % 24 / 2]);
        builder.append(hour % 2 == 0 ? (char)'\u6b63' : '\u521d');
    }

    public static String formatDateTime(TemporalAccessor time) {
        LocalDateTime localDateTime = time instanceof Instant ? ((Instant)time).atZone(ZoneId.systemDefault()).toLocalDateTime() : LocalDateTime.from(time);
        StringBuilder builder = new StringBuilder(16);
        WenyanUtils.appendYear(builder, localDateTime.getYear());
        builder.append('\u5e74');
        builder.append(WenyanUtils.numberToString(localDateTime.getMonthValue()));
        builder.append('\u6708');
        builder.append(WenyanUtils.numberToString(localDateTime.getDayOfMonth()));
        builder.append('\u65e5');
        builder.append(' ');
        WenyanUtils.appendHour(builder, localDateTime.getHour());
        builder.append(WenyanUtils.numberToString(localDateTime.getMinute()));
        builder.append('\u5206');
        builder.append(WenyanUtils.numberToString(localDateTime.getSecond()));
        builder.append('\u79d2');
        return builder.toString();
    }

    public static String translateGameVersion(GameVersionNumber gameVersion) {
        if (gameVersion instanceof GameVersionNumber.Release) {
            GameVersionNumber.Release release = (GameVersionNumber.Release)gameVersion;
            StringBuilder builder = new StringBuilder();
            WenyanUtils.appendDigitByDigit(builder, String.valueOf(release.getMajor()));
            builder.append(DOT);
            WenyanUtils.appendDigitByDigit(builder, String.valueOf(release.getMinor()));
            if (release.getPatch() != 0) {
                builder.append(DOT);
                WenyanUtils.appendDigitByDigit(builder, String.valueOf(release.getPatch()));
            }
            if (release.getEaType() != Integer.MAX_VALUE) {
                if (release.getEaType() == 2) {
                    builder.append("\u4e4b\u9810");
                    WenyanUtils.appendDigitByDigit(builder, release.getEaVersion().toString());
                } else if (release.getEaType() == 3) {
                    builder.append("\u4e4b\u5019");
                    WenyanUtils.appendDigitByDigit(builder, release.getEaVersion().toString());
                } else {
                    return gameVersion.toString();
                }
            }
            return builder.toString();
        }
        if (gameVersion instanceof GameVersionNumber.Snapshot) {
            GameVersionNumber.Snapshot snapshot = (GameVersionNumber.Snapshot)gameVersion;
            StringBuilder builder = new StringBuilder();
            WenyanUtils.appendDigitByDigit(builder, String.valueOf(snapshot.getYear()));
            builder.append('\u9031');
            WenyanUtils.appendDigitByDigit(builder, String.valueOf(snapshot.getWeek()));
            char suffix = snapshot.getSuffix();
            if (suffix >= 'a' && suffix - 97 < TIAN_GAN.length) {
                builder.append(TIAN_GAN[suffix - 97]);
            } else {
                builder.append(suffix);
            }
            return builder.toString();
        }
        if (gameVersion instanceof GameVersionNumber.Special) {
            String version = gameVersion.toString();
            switch (version.toLowerCase(Locale.ROOT)) {
                case "2.0": {
                    return "\u4e8c\u9ede\u3007";
                }
                case "2.0_blue": {
                    return "\u4e8c\u9ede\u3007\u85cd";
                }
                case "2.0_red": {
                    return "\u4e8c\u9ede\u3007\u8d64";
                }
                case "2.0_purple": {
                    return "\u4e8c\u9ede\u3007\u7d2b";
                }
                case "1.rv-pre1": {
                    return "\u4e00\u9ede\u771f\u8996\u4e4b\u9810\u4e00";
                }
                case "3d shareware v1.34": {
                    return "\u8e8d\u7136\u4eab\u4ef6\u4e00\u9ede\u4e09\u56db";
                }
                case "20w14infinite": 
                case "20w14~": 
                case "20w14\u221e": {
                    return "\u4e8c\u3007\u9031\u4e00\u56db\u5b87";
                }
                case "22w13oneblockatatime": {
                    return "\u4e8c\u4e8c\u9031\u4e00\u4e09\u5178";
                }
                case "23w13a_or_b": {
                    return "\u4e8c\u4e09\u9031\u4e00\u4e09\u66a8";
                }
                case "24w14potato": {
                    return "\u4e8c\u56db\u9031\u4e00\u56db\u828b";
                }
                case "25w14craftmine": {
                    return "\u4e8c\u4e94\u9031\u4e00\u56db\u7926";
                }
            }
            return version;
        }
        return gameVersion.toString();
    }

    public static String translateGenericVersion(String version) {
        Matcher matcher = GENERIC_VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            String prefix = matcher.group();
            StringBuilder builder = new StringBuilder(version.length());
            for (int i = 0; i < prefix.length(); ++i) {
                char ch = prefix.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    builder.append(WenyanUtils.digitToString(ch));
                    continue;
                }
                if (ch == '.') {
                    builder.append(DOT);
                    continue;
                }
                builder.append(ch);
            }
            builder.append(version, prefix.length(), version.length());
            return builder.toString();
        }
        return version;
    }

    private WenyanUtils() {
    }
}

